# Glyph of Glyphs font

## 説明
　グリフフォントです。
グリフ名とアスタリスクを組み合わせるとグリフに変換します。
　アルファベット部分は、[Source Han Code JP](https://github.com/adobe-fonts/source-han-code-jp)を利用しています。

#### 対応ツール
* Adobe PhotoShop
* Adobe Illustrator
* Gimp2
* Atom
* Windows10のメモ帳
* ...等、リガチャーに対応したツール

## 入力ルール

* 最初は大文字で、次から小文字、最後にアスタリスク
* 一つのグリフに複数の単語がある場合、単語が切り替わるところは、空白を無くし大文字とする(Camel Case → CamelCase)
* XMやN'Zeerは例外

#### 入力例
|グリフ名  |入力      |
|----------|----------|
|Abandon   |Abandon*  |
|Live Again|LiveAgain*|
|XM        |XM*       |
|XM        |Xm*       |
|N'Zeer    |N'Zeer*   |
|N'Zeer    |NZeer*    |
|N'Zeer    |Nzeer*    |

同梱のglyph.txtを参考にしてください。

また、表示テストとしてtest.htmlを同梱しています。フォントをインストール後にブラウザで開いてください。

空白グリフをスペース(U+0020)及び改行禁止スペース(U+00A0)のスタイルセットとして追加しました。AdobeのツールやMS Word等スタイルセットを指定できるツールからスタイルセット01に変える事で、ラインの無いグリフを表示できます。test.htmlでも利用しています。

Chromeでは、スペースのグリフ変更はできないようですので、改行禁止スペースをご利用ください。
　
## ライセンス
　ライセンスは、[SIL Open Font License](http://scripts.sil.org/OFL)です。
　個人または商用で自由にご利用できます。

## 連絡先
　[くだらないページ](http://www.ku-da.net/)
 
### 履歴
|日付      |Version  |コメント                                      |
|----------|---------|----------------------------------------------|
|2019.08.01| 004.002 |Nemesis、Field、Key、Link、Shield、Starのグリフを追加、空白グリフをスペース(U+0020)及び改行禁止スペース(U+00A0)のスタイルセットとして追加|
|2019.06.03| 003.000 |Osiris、Yourのグリフを追加                    |
|2019.04.10| 002.000 |Toastのグリフを追加                           |
|2019.02.04| 001.001a|ライセンス中の連絡先を更新                    |
|2018.04.11| 001.001 |Acceptの抜けを修正。Ideaのグリフ間違いを修正。|
|2018.04.10| 001.000 |初回リリース。                                |
